define([
    'marionette',
    'Layout',
    'modules/new-appointment-wizard/wizard-step-model',
    'modules/new-appointment-wizard/wizard-layout-view',
],
function(Marionette, Layout, WizardStepModel, WizardLayoutView) {
    'use strict';

    describe('Wizard Step Layout View', function() {
        var view;
        var $view;
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            spyOn(WizardLayoutView.prototype, 'showCurrentWizardPageLayout');

            view = new WizardLayoutView({model: new WizardStepModel()});

            layout.showChildView('content', view);
            $view = view.$el;
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        it('can show and hide the error section', function() {
            expect($view.find('.error-section').hasClass('hidden')).toEqual(true);
            view.showErrorSection();
            expect($view.find('.error-section').hasClass('hidden')).toEqual(false);
            view.hideErrorSection();
            expect($view.find('.error-section').hasClass('hidden')).toEqual(true);
        });
        it('has back button to return to <<New Appointment/Request>>', function() {
            var backButton = $view.find('#back-btn');
            expect(backButton.length).toEqual(1);
        });
        it('has a primary content header', function() {
            expect($view.find('.primary-header').find('h2')
                .text()).toEqual('New Appointment/Request');
        });
        it('has regions to show form sections', function() {
            expect($view.has(view.regions.currentWizardPageLayout).length).toEqual(1);
        });

        describe('on show', function() {
            it('show the current wizard page layout view', function () {
                expect(view.showCurrentWizardPageLayout).toHaveBeenCalled();
            });
        });
    });
}
);
